unit xMouse;

(**************************************************************)
(** //              XENGINE Mouse Unit                    // **)
(** //  (C) 2025 Coded by Adam Kozinski & Dominik Galoch  // **)
(** //////////////////////////////////////////////////////// **)
(**************************************************************)

interface

type
    TCursor = array[1..32] of word; { Type for the graphical cursor mask }

var
    MOUSE_LEFT, MOUSE_MIDDLE, MOUSE_RIGHT : boolean;
    MOUSE_X, MOUSE_Y : word;

{ HEADERS OF PROCEDURES AND FUNCTIONS }
{//////////////////////////////////////////////////////////}

function xMouseInit : boolean;                                  { Check if mouse is installed }
procedure xShowMouse;                                           { Show mouse cursor }
procedure xHideMouse;                                           { Hide mouse cursor }
procedure xResetMouse;                                          { Reset mouse cursor }
procedure xSetMousePosition(PosX, PosY : word);                 { Set mouse cursor position on screen }
procedure xMouseUpdate;                                         { Update mouse status }
procedure xSetMouseSpeed(SpeedX, SpeedY : word);                { Set mouse speed }
procedure xSetMouseArea(MinX, MaxX, MinY, MaxY : word);         { Set mouse movement area on screen }
procedure xSetMouseCursor(HotX, HotY : word; Cursor : TCursor); { Set graphical mouse cursor mask }

{//////////////////////////////////////////////////////////}

implementation

(***********************************************************)

function xMouseInit : boolean;
begin
    asm
        mov ax, 0000h                   { Load 0000h into AX }
        int 33h                         { Call interrupt 33h }
        mov @result, al
    end;
end;

(***********************************************************)

procedure xShowMouse;
begin
    asm
        mov ax, 0001h                   { Load 0001h into AX }
        int 33h                         { Call interrupt 33h }
    end;
end;

(***********************************************************)

procedure xHideMouse;
begin
    asm
        mov ax, 0002h                   { Load 0002h into AX }
        int 33h                         { Call interrupt 33h }
    end;
end;

(***********************************************************)

procedure xResetMouse;
begin
    xHideMouse;
    xShowMouse;
end;

(***********************************************************)

procedure xSetMousePosition(PosX, PosY : word);
begin
    asm
        mov ax, 0004h                   { Load interrupt code 33h for setting cursor position }
        mov cx, PosX                    { Load X value into CX }
        mov dx, PosY                    { Load Y value into DX }
        int 33h                         { Call interrupt 33h }
    end;
end;

(***********************************************************)

procedure xSetMouseSpeed(SpeedX, SpeedY : word);
begin
    asm
        mov ax, 001Ah
        mov bx, SpeedX
        mov cx, SpeedY
        int 33h
    end;
end;

(***********************************************************)

procedure xMouseUpdate;
var
  temp : word;
  temp_pos_x, temp_pos_y : word;
begin
  asm
      mov ax, 0003h                   { Load 0003h into AX }
      int 33h                         { Call interrupt 33h }
      mov word ptr temp, bx           { Load BX into temp }
      mov word ptr temp_pos_x, cx     { Load CX into temp_pos_x }
      mov word ptr temp_pos_y, dx     { Load DX into temp_pos_y }
  end;

  MOUSE_X := temp_pos_x shr 1;
  MOUSE_Y := temp_pos_y;

  if ( (temp and $01) <> 0 ) then MOUSE_LEFT := TRUE else MOUSE_LEFT := FALSE;
  if ( (temp and $02) <> 0 ) then MOUSE_RIGHT := TRUE else MOUSE_RIGHT := FALSE;
  if ( (temp and $04) <> 0 ) then MOUSE_MIDDLE := TRUE else MOUSE_MIDDLE := FALSE;
end;

(***********************************************************)

procedure xSetMouseArea(MinX, MaxX, MinY, MaxY : word);
begin
    asm
        mov ax, 0007h
        shl MinX, 1
        shl MaxX, 1
        mov cx, MinX
        mov dx, MaxX
        int 33h
        mov ax, 0008h
        mov cx, MinY
        mov dx, MaxY
        int 33h
    end;
end;

(***********************************************************)

procedure xSetMouseCursor(HotX, HotY : word; Cursor : TCursor);
var
    c_seg, c_ofs : word;
begin
    c_seg := Seg(Cursor);
    c_ofs := Ofs(Cursor);
    asm
        mov ax, 0009h
        mov bx, HotX
        mov cx, HotY
        mov es, c_seg
        mov dx, c_ofs
        int 33h
    end;
end;

(***********************************************************)

end.